/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Gfx logo    , // logo image
    fade    ; // fading texture
Flt fx_value; // effect value
Int fx_index; // effect index
/******************************************************************************/
void InitPre()
{
   App.name="2D Effects";
   App.flag=APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");
   D.mode(800,600);
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   // import esenthel engine logo
   logo.Import("../data/logo.png",-1,GFX_2D);

   // create fading texture
   fade.create2D(128,128, GFX_L8, 1);
   if(fade.lock())
   {
      REPD(x,fade.x())
      REPD(y,fade.y())fade.pixel(x,y,Rnd(256));
      fade.unlock();
   }
   fade.blur(5,false); // apply gaussian blur with 5 pixel range and no clamping

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   // change effect on key pressed, and reset effect value
   if(Kb.bp(KB_1)){fx_index=1; fx_value=0;}
   if(Kb.bp(KB_2)){fx_index=2; fx_value=0;}
   if(Kb.bp(KB_3)){fx_index=3; fx_value=0;}
   if(Kb.bp(KB_4)){fx_index=4; fx_value=0;}
   if(Kb.bp(KB_5)){fx_index=5; fx_value=0;}
   if(Kb.bp(KB_6)){fx_index=6; fx_value=0;}

   // increase effect value
   fx_value+=Tm.d;

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);

   if(Kb.b(KB_SPACE))fade.drawFs();else // if space pressed draw fading texture to full screen
   switch(fx_index)
   {
      case 0:
      {
         D.text(0,0,"Press 1,2,3,4,5,6 keys to view different effects");
      }break;

      case 1: // Draw Ripple Effect through Gfx::draw()
      {
         // set ripple effect values
         RippleFx ripple;
         ripple.alpha_add  = fx_value;
         ripple.alpha_scale=-1;

         // draw image with ripple effect
         logo.draw(ripple, -1,1,2,2);
      }break;

      case 2: // Draw Ripple Effect through helper screen
      {
         // draw to helper screen
         D.fxBegin();         // start drawing to helper screen
         logo.draw(-1,1,2,2); // image draw
         D.fxEnd();           // restore default screen drawing

         // set ripple effect values
         RippleFx ripple;
         ripple.alpha_add  = fx_value;
         ripple.alpha_scale=-1;

         // draw helper screen with ripple effect
         ripple.draw();
      }break;

      case 3: // Draw Fade Effect
      {
         // draw to helper screen
         D.fxBegin();         // start drawing to helper screen
         logo.draw(-1,1,2,2); // image draw
         D.fxEnd();           // restore default screen drawing

         // fade in helper screen with 'fade' fading texture
         FadeFx(fx_value/2,&fade);
      }break;

      case 4: // Titles Effect
      {
         // draw to helper screen
         D.fxBegin();                                                      // start drawing to helper screen
         REP(30)D.text(0,D.h()+(Frac(Tm.time())-i)*0.08,"Text Text Text"); // draw text
         D.fxEnd();                                                        // restore default screen drawing

         // set effect values
         TitlesFx titles;

         // draw helper screen with titles effect
         titles.draw();
      }break;

      case 5: // Wave Effect
      {
         logo.drawFs();           // draw logo on full screen
         WaveFx(Tm.time()/2,0.8); // apply wave effect onto the full screen
      }break;

      case 6: // Radial Blur Effect
      {
         logo.drawFs();                    // draw logo on full screen
         RadialBlurFx(Frac(fx_value)*0.3); // apply radial blur effect onto the full screen
      }break;
   }
}
/******************************************************************************/
